<?php
require_once '../config.php';
verificarLogin();

$titulo = "Criar Plano";
$security = new Security($pdo);

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Verificar CSRF
    if (!$security->verifyCSRFToken($_POST['csrf_token'])) {
        die("Token CSRF inválido!");
    }
    
    $nome = $security->cleanInput($_POST['nome']);
    $tipo = $security->cleanInput($_POST['tipo']);
    $dias = $security->cleanInput($_POST['dias']);
    $valor = $security->cleanInput($_POST['valor']);
    $creditos = $security->cleanInput($_POST['creditos']);
    
    try {
        $stmt = $pdo->prepare("INSERT INTO planos (usuario_id, nome, tipo, dias, valor, creditos) VALUES (?, ?, ?, ?, ?, ?)");
        $stmt->execute([$_SESSION['usuario_id'], $nome, $tipo, $dias, $valor, $creditos]);
        
        // Registrar na auditoria
        $stmt = $pdo->prepare("INSERT INTO security_logs (usuario_id, acao, ip_address, user_agent) VALUES (?, ?, ?, ?)");
        $stmt->execute([$_SESSION['usuario_id'], 'criar_plano', $_SERVER['REMOTE_ADDR'], $_SERVER['HTTP_USER_AGENT']]);
        
        header("Location: planos.php?sucesso=1");
        exit();
    } catch (PDOException $e) {
        $erro = "Erro ao criar plano: " . $e->getMessage();
    }
}

$csrf_token = $security->generateCSRFToken();
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $titulo; ?> - Gestor DREEYTV</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        :root {
            --primary: #667eea;
            --secondary: #2d3748;
            --danger: #f56565;
        }
        
        body {
            background: #f5f7fa;
            color: #2d3748;
        }
        
        .admin-container {
            display: flex;
            min-height: 100vh;
        }
        
        .sidebar {
            width: 280px;
            background: var(--secondary);
            color: white;
        }
        
        .sidebar-header {
            padding: 30px 25px;
            background: rgba(0,0,0,0.2);
            border-bottom: 1px solid rgba(255,255,255,0.1);
        }
        
        .sidebar-header h2 {
            font-size: 1.5rem;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .sidebar-menu {
            list-style: none;
            padding: 20px 0;
        }
        
        .sidebar-menu li {
            margin: 5px 15px;
        }
        
        .sidebar-menu a {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 15px 20px;
            color: rgba(255,255,255,0.8);
            text-decoration: none;
            border-radius: 10px;
            transition: all 0.3s;
        }
        
        .sidebar-menu a:hover {
            background: rgba(255,255,255,0.1);
            color: white;
        }
        
        .sidebar-menu a.active {
            background: var(--primary);
            color: white;
        }
        
        .main-content {
            flex: 1;
            padding: 30px;
        }
        
        .header {
            background: white;
            padding: 25px 30px;
            border-radius: 15px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
            margin-bottom: 30px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .header h1 {
            font-size: 1.8rem;
            background: linear-gradient(135deg, var(--primary), #5a6fd8);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }
        
        .user-info {
            display: flex;
            align-items: center;
            gap: 15px;
        }
        
        .user-avatar {
            width: 45px;
            height: 45px;
            border-radius: 50%;
            background: linear-gradient(135deg, var(--primary), #5a6fd8);
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: bold;
        }
        
        .content {
            background: white;
            padding: 30px;
            border-radius: 15px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
            max-width: 600px;
            margin: 0 auto;
        }
        
        .form-header {
            text-align: center;
            margin-bottom: 30px;
        }
        
        .form-header .icon {
            font-size: 3rem;
            margin-bottom: 10px;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        .form-label {
            display: block;
            margin-bottom: 8px;
            font-weight: 600;
            color: #2d3748;
        }
        
        .form-control {
            width: 100%;
            padding: 15px;
            border: 2px solid #e2e8f0;
            border-radius: 10px;
            font-size: 16px;
            transition: all 0.3s;
        }
        
        .form-control:focus {
            border-color: var(--primary);
            outline: none;
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        }
        
        textarea.form-control {
            min-height: 100px;
            resize: vertical;
        }
        
        .btn {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            padding: 15px 25px;
            background: var(--primary);
            color: white;
            text-decoration: none;
            border-radius: 10px;
            font-weight: 600;
            transition: all 0.3s;
            border: none;
            cursor: pointer;
            font-size: 16px;
        }
        
        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(102, 126, 234, 0.3);
        }
        
        .btn-block {
            display: block;
            width: 100%;
        }
        
        .btn-danger {
            background: var(--danger);
        }
        
        .btn-danger:hover {
            box-shadow: 0 5px 15px rgba(245, 101, 101, 0.3);
        }
        
        .form-actions {
            display: flex;
            gap: 15px;
            margin-top: 30px;
        }
        
        .alert {
            padding: 15px;
            border-radius: 10px;
            margin-bottom: 20px;
        }
        
        .alert-danger {
            background: #fed7d7;
            color: #742a2a;
            border: 1px solid #feb2b2;
        }
        
        @media (max-width: 768px) {
            .admin-container {
                flex-direction: column;
            }
            
            .sidebar {
                width: 100%;
            }
            
            .form-actions {
                flex-direction: column;
            }
        }
    </style>
</head>
<body>
    <div class="admin-container">
        <div class="sidebar">
            <div class="sidebar-header">
                <h2>📺 GESTOR DREEYTV</h2>
            </div>
            <ul class="sidebar-menu">
                <li><a href="../index.php">📊 Dashboard</a></li>
                <li><a href="../clientes/clientes.php">👨‍💼 Clientes</a></li>
                <li><a href="planos.php">📋 Planos</a></li>
                <li><a href="../servidores/servidores.php">🖥️ Servidores</a></li>
                <?php if ($_SESSION['usuario_tipo'] == 'admin'): ?>
                    <li><a href="../usuarios/usuarios.php">👥 Usuários</a></li>
                <?php endif; ?>
                <li><a href="../senha/alterar_senha.php">🔑 Alterar Senha</a></li>
                <li><a href="../logout.php">🚪 Sair</a></li>
            </ul>
        </div>
        
        <div class="main-content">
            <div class="header">
                <h1>Criar Plano</h1>
                <div class="user-info">
                    <div class="user-avatar"><?php echo substr($_SESSION['usuario_nome'], 0, 1); ?></div>
                    <div>
                        <div style="font-weight: 600;"><?php echo $_SESSION['usuario_nome']; ?></div>
                        <div style="font-size: 0.9rem; color: #666;"><?php echo ucfirst($_SESSION['usuario_tipo']); ?></div>
                    </div>
                    <a href="../logout.php" class="btn" style="background: var(--danger);">🚪 Sair</a>
                </div>
            </div>
            
            <div class="content">
                <div class="form-header">
                    <div class="icon">📋</div>
                    <h2>Novo Plano</h2>
                    <p style="color: #666;">Crie um novo plano para oferecer aos clientes</p>
                </div>
                
                <?php if (isset($erro)): ?>
                    <div class="alert alert-danger">
                        <strong>❌ Erro:</strong> <?php echo $erro; ?>
                    </div>
                <?php endif; ?>
                
                <form method="POST">
                    <input type="hidden" name="csrf_token" value="<?php echo $csrf_token; ?>">
                    
                    <div class="form-group">
                        <label class="form-label" for="nome">🏷️ Nome do Plano</label>
                        <input type="text" id="nome" name="nome" class="form-control" placeholder="Ex: Plano Básico, Plano Premium" required
                               value="<?php echo isset($_POST['nome']) ? htmlspecialchars($_POST['nome']) : ''; ?>">
                    </div>
                    
                    <div class="form-group">
                        <label class="form-label" for="tipo">🎯 Tipo de Plano</label>
                        <input type="text" id="tipo" name="tipo" class="form-control" placeholder="Ex: Básico, Premium, VIP" required
                               value="<?php echo isset($_POST['tipo']) ? htmlspecialchars($_POST['tipo']) : ''; ?>">
                    </div>
                    
                    <div class="form-group">
                        <label class="form-label" for="dias">📅 Duração (dias)</label>
                        <input type="number" id="dias" name="dias" class="form-control" min="1" placeholder="30" required
                               value="<?php echo isset($_POST['dias']) ? htmlspecialchars($_POST['dias']) : ''; ?>">
                    </div>
                    
                    <div class="form-group">
                        <label class="form-label" for="valor">💰 Valor (R$)</label>
                        <input type="number" id="valor" name="valor" class="form-control" step="0.01" min="0" placeholder="29.90" required
                               value="<?php echo isset($_POST['valor']) ? htmlspecialchars($_POST['valor']) : ''; ?>">
                    </div>
                    
                    <div class="form-group">
                        <label class="form-label" for="creditos">💳 Créditos/Descrição</label>
                        <textarea id="creditos" name="creditos" class="form-control" placeholder="Descreva os créditos ou benefícios do plano..."><?php echo isset($_POST['creditos']) ? htmlspecialchars($_POST['creditos']) : ''; ?></textarea>
                    </div>
                    
                    <div class="form-actions">
                        <button type="submit" class="btn btn-block">✅ Criar Plano</button>
                        <a href="planos.php" class="btn btn-danger btn-block">❌ Cancelar</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</body>
</html>